/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Localisation;
import cds.aladin.Tok;
import cds.tools.Util;

public final class CommandDS9 {
    private Aladin aladin;
    private int previousFrame = 5;
    private int currentFrame = -1;
    private static String SAOTNFORMATERROR = "!!!SAOTN compatibility error (format parsing failed)";
    private static String[] STCKEYS = new String[]{"LOCAL_GROUP_CENTER", "GALACTIC_CENTER", "UNKNOWNRefPos", "EMBARYCENTER", "HELIOCENTER", "BARYCENTER", "TOPOCENTER", "GEOCENTER", "JUPITER", "MERCURY", "NEPTUNE", "URANUS", "SATURN", "PLUTO", "VENUS", "LSRD", "LSRK", "MOON", "MARS", "LSR"};
    private static final String[] TEST = new String[]{"# Region file format: DS9 version 4.1", "# Filename: C:/Documents and Settings/Standard/Mes documents/Fits et XML/dss1.fits", "global color=green dashlist=8 3 width=1 font=\"helvetica 10 normal\" select=1 highlite=1 dash=0 fixed=0 edit=1 move=1 delete=1 include=1 source=1", "fk5", "circle(83.660376,22.042708,31.940586\")", "ellipse(83.585086,22.03882,79.491097\",38.786247\",351.70206)", "box(83.690273,22.020911,67.517674\",45.347692\",359.61543)", "polygon(83.63402,22.012313,83.621943,22.012238,83.622024,22.001041,83.634101,22.001117)", "polygon 83.610533 22.011943 83.584443 22.011775", "line(83.661236,22.006322,83.671597,21.992668) # line=0 0", "ecliptic;line(83.646735,22.007633,83.627889,21.983442) # line=0 0", "#  vector(83.702004,22.049953,94.710207\",20.171478) vector=1", "# text(83.646667,22.01715) color=red width=2 text={Region}", "# composite(83.667432,22.012471,23.324274) || composite=1", "point(83.667432,22.012471) || # point=boxcircle", "  point  83.667432  22.012471  ", "text(84.059752,21.854908) || textangle=22.939706 text={S0}", "polygon(84.099463,21.761356,83.958987,21.817998,84.019991,21.948451,84.16057,21.891758) ||", "b1950; circle 82.907937d 22.010159d 31.940586", "circle(83.660376,22.042708,31.940586\")", "# Region STC ", "stc POLYGON ICRS 172.3051205700001 29.00697160000002 172.35133123000008 29.000585790000006 172.3475670999997 28.98066108000001 172.33490575999994 28.98246860000003 172.33324013999982 28.973249709999987 172.32257678999994 28.974723670000003 172.32063336000007 28.963602760000004 172.29783566999998 28.966582310000014", "draw stc POLYGON ICRS 172.3051205700001 29.00697160000002 172.35133123000008 29.000585790000006 172.3475670999997 28.98066108000001 172.33490575999994 28.98246860000003 172.33324013999982 28.973249709999987 172.32257678999994 28.974723670000003 172.32063336000007 28.963602760000004 172.29783566999998 28.966582310000014"};

    public CommandDS9(Aladin aladin) {
        this.aladin = aladin;
    }

    public String translate(String s) throws Exception {
        StringBuffer s1 = null;
        if (this.aladin != null) {
            this.previousFrame = this.aladin.localisation.getFrame();
        }
        Tok tok = new Tok(s, ";");
        int nbCmd = 0;
        while (tok.hasMoreTokens()) {
            String a = this.translateOne(tok.nextToken());
            if (a == null) continue;
            if (a.length() >= 0 && s1 == null) {
                s1 = new StringBuffer();
            }
            if (a.length() == 0) continue;
            if (s1.length() > 0) {
                s1.append(';');
            }
            s1.append(a);
            ++nbCmd;
        }
        if (s1 == null) {
            return null;
        }
        if (nbCmd > 1 && this.currentFrame != -1 && !Localisation.isSameFrame(this.previousFrame, this.currentFrame)) {
            s1.append(";setconf frame=" + Localisation.getFrameName(this.previousFrame));
        }
        return s1.toString();
    }

    public String translateOne(String s) throws Exception {
        if ((s = this.trimCom(s)) == null) {
            return null;
        }
        Tok tok = new Tok(s, "( ");
        String cmd = tok.nextToken();
        if (cmd.equalsIgnoreCase("draw") && tok.nextToken().equalsIgnoreCase("stc")) {
            return this.translateOne(s.substring(cmd.length()));
        }
        if (cmd.equalsIgnoreCase("stc")) {
            return this.translateOne(s.substring(cmd.length()));
        }
        if (cmd.equalsIgnoreCase("circle") || cmd.equalsIgnoreCase("line") || cmd.equalsIgnoreCase("polygon") || cmd.equalsIgnoreCase("box") || cmd.equalsIgnoreCase("global") || cmd.equalsIgnoreCase("ellipse")) {
            return this.basicDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("rotbox")) {
            return this.rotboxCIAtoAladin(s);
        }
        if (cmd.equalsIgnoreCase("ruler")) {
            return this.rulerDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("point")) {
            return this.pointDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("vector")) {
            return this.basicDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("text")) {
            return this.textDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("composite")) {
            return this.compositeDS9toAladin(s);
        }
        if (cmd.equalsIgnoreCase("format:")) {
            return this.formatSAOTNtoAladin(s);
        }
        if (cmd.equalsIgnoreCase("region")) {
            return this.formatCIAOtoAladin(s);
        }
        if (cmd.equalsIgnoreCase("fk5") || cmd.equalsIgnoreCase("j2000") || cmd.equalsIgnoreCase("fk4") || cmd.equalsIgnoreCase("b1950") || cmd.equalsIgnoreCase("galactic") || cmd.equalsIgnoreCase("ecliptic") || cmd.equalsIgnoreCase("icrs") || cmd.equalsIgnoreCase("image")) {
            return this.frameDS9toAladin(s);
        }
        return null;
    }

    private String trimCom(String s) {
        char c;
        int i;
        if (s == null) {
            return null;
        }
        int n = s.length();
        for (i = 0; i < n && ((c = s.charAt(i)) == '#' || c == '+' || Character.isSpace(c)); ++i) {
        }
        return i == 0 ? s : (i == n ? null : s.substring(i));
    }

    private String rulerDS9toAladin(String cmd) throws Exception {
        int i = cmd.indexOf("ruler");
        return this.basicDS9toAladin("dist" + cmd.substring(i + 5));
    }

    private String rotboxCIAtoAladin(String cmd) throws Exception {
        int i = cmd.indexOf("rot");
        return this.basicDS9toAladin(cmd.substring(i + 3));
    }

    private String formatCIAOtoAladin(String cmd) throws Exception {
        if (cmd.indexOf("CIAO version") < 0) {
            return null;
        }
        return this.frameDS9toAladin("J2000");
    }

    private String formatSAOTNtoAladin(String cmd) throws Exception {
        int deb = cmd.lastIndexOf(40);
        int fin = cmd.indexOf(41, deb);
        if (deb < 0 || fin < 0) {
            throw new Exception(SAOTNFORMATERROR);
        }
        return this.frameDS9toAladin(cmd.substring(deb + 1, fin));
    }

    private String textDS9toAladin(String cmd) throws Exception {
        boolean saotng = false;
        int fin = 0;
        int deb = cmd.lastIndexOf("text={");
        if (deb < 0) {
            saotng = true;
        } else {
            fin = cmd.indexOf("}", deb += 6);
        }
        Tok tok = new Tok(cmd, "( ,)");
        tok.nextToken();
        String s = "draw string(" + tok.nextToken() + "," + tok.nextToken() + "," + Tok.quote(saotng ? tok.nextToken() : cmd.substring(deb, fin)) + ")";
        return s;
    }

    private String pointDS9toAladin(String cmd) throws Exception {
        Tok tok = new Tok(cmd, "( ,)");
        tok.nextToken();
        return "draw tag(" + tok.nextToken() + "," + tok.nextToken() + ")";
    }

    private String compositeDS9toAladin(String cmd) throws Exception {
        Tok tok = new Tok(cmd, "( ,)");
        tok.nextToken();
        return "draw newfov(" + tok.nextToken() + "," + tok.nextToken() + ")";
    }

    private String frameDS9toAladin(String cmd) throws Exception {
        int frame = -1;
        if (cmd.equals("fk5") || cmd.equals("j2000")) {
            frame = 5;
        } else if (cmd.equals("icrs")) {
            frame = 0;
        } else if (cmd.equals("fk4") || cmd.equals("b1950")) {
            frame = 7;
        } else if (cmd.equals("galactic")) {
            frame = 3;
        } else if (cmd.equals("ecliptic")) {
            frame = 2;
        } else if (cmd.equals("image")) {
            frame = 11;
        } else {
            return null;
        }
        if (frame == this.previousFrame) {
            return "";
        }
        this.currentFrame = frame;
        return "setconf frame=" + Localisation.getFrameName(this.currentFrame);
    }

    private String basicDS9toAladin(String cmd) throws Exception {
        int c;
        String frame = null;
        int c1 = cmd.indexOf(35);
        int c2 = cmd.indexOf(124);
        int c3 = cmd.indexOf(41);
        int n = c3 > 0 ? c3 + 1 : (c1 > 0 && c2 > 0 ? Math.min(c1, c2) : (c = c1 > 0 ? c1 : c2));
        if (c == -1) {
            c = cmd.length();
        }
        cmd = cmd.substring(0, c).trim();
        Tok tok = new Tok(cmd, "( ,)");
        StringBuffer s = new StringBuffer("draw " + tok.nextToken().toLowerCase() + "(");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (this.isSTCKeyword(t)) continue;
            if (!first) {
                s.append(',');
            } else if (!Character.isDigit(t.charAt(0))) {
                frame = "setconf frame=" + t + ";";
                continue;
            }
            first = false;
            s.append(Tok.quote(t));
        }
        s.append(')');
        return (frame != null ? frame : "") + s.toString();
    }

    private boolean isSTCKeyword(String s) {
        return Util.indexInArrayOf(s, STCKEYS, true) >= 0;
    }

    public static void main(String[] argv) {
        int i;
        CommandDS9 ds9 = new CommandDS9(null);
        for (i = 0; i < TEST.length; ++i) {
            System.out.println(TEST[i]);
        }
        System.out.println();
        for (i = 0; i < TEST.length; ++i) {
            String s;
            try {
                s = ds9.translate(TEST[i]);
            }
            catch (Exception e) {
                s = "Exception: " + e.getMessage();
                e.printStackTrace();
            }
            System.out.println(s == null ? "null" : s);
        }
    }
}

